	function [Zm] = lp_find_arcmin_epb(Z,NIN)
	% 
	% Finds the arc minimum frequencies to the left of the first 
	% attenuation pole, given the attenuation pole vector Z 
	% and the number of attenuation poles at infinity NIN.

	% Author: 			Per Loewenborg
    % Modified by:		LW
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	N = length(Z);
	Zm = [];
	if NIN > 0 
		if N > 1 
			for k = 1:N-1
				ZA = Z(k);
				ZB = Z(k+1);
				ZZA = ZA*ZA;
				ZZB = ZB*ZB;
				ZZ0 = ZA*ZB;
				D0 = lp_d_func(Z,NIN,ZZ0);
				ZZ1 = ZZ0-1e-6;
				while abs(ZZ1-ZZ0) > 1e-9  % Shall be smaller than the tolerance above.
					D1 = lp_d_func(Z,NIN,ZZ1);
					ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
					if (ZZ2 < ZZA)
						ZZ2 = ZZA+0.001;      
					end 			   
					if (ZZ2 > ZZB)
						ZZ2 = ZZB-0.01;
					end 			   
					D0 = D1;
					ZZ0 = ZZ1;
					ZZ1 = ZZ2;
				end 			   
				Zm = [Zm sqrt(ZZ2)];
			end 			   
			% Last arc
			ZA = Z(N);
			ZZA = ZA*ZA;
			ZZ0 = ZA;
			ZZ0 = (((NIN/2)*ZA+1)/(ZA+(NIN/2)))*ZZ0;
			D0 = lp_d_func(Z,NIN,ZZ0);
			ZZ1 = ZZ0-1e-6;
			while abs(ZZ1-ZZ0) > 1e-9    % Shall be smaller than the tolerance above.
				D1 = lp_d_func(Z,NIN,ZZ1);
				ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
				if (ZZ2 < ZZA)
					ZZ2 = ZZA+0.0001;      
				end
				if (ZZ2 > 1)
					ZZ2 = 0.9999;
				end
				D0 = D1;
				ZZ0 = ZZ1;
				ZZ1 = ZZ2;
			end         
			Zm = [Zm sqrt(ZZ2)];
			
		elseif N == 1
			ZA = Z(N);
			ZZA = ZA*ZA;
			ZZ0 = ZA;
			ZZ0 = (((NIN/2)*ZA+1)/(ZA+(NIN/2)))*ZZ0;
			D0 = lp_d_func(Z,NIN,ZZ0);
			ZZ1 = ZZ0-1e-6;
			while abs(ZZ1-ZZ0) > 1e-9    % Shall be smaller than the tolerance above.
				D1 = lp_d_func(Z,NIN,ZZ1);
				ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
				if (ZZ2 < ZZA)
					ZZ2 = ZZA+0.001;      
				end
				if (ZZ2 > 1)
					ZZ2 = 0.99;
				end
				D0 = D1;
				ZZ0 = ZZ1;
				ZZ1 = ZZ2;
			end    
			Zm = [Zm sqrt(ZZ2)];
		else  
			disp('Note: No finite zeros')
		end  
	elseif NIN == 0  
		if N > 1    
			for k = 1:N-1
				ZA = Z(k);
				ZB = Z(k+1);
				ZZA = ZA*ZA;
				ZZB = ZB*ZB;
				ZZ0 = ZA*ZB;
				D0 = lp_d_func(Z,NIN,ZZ0);
				ZZ1 = ZZ0-1e-6;
				while abs(ZZ1-ZZ0) > 1e-9  % Shall be smaller than the tolerance above.
					D1 = lp_d_func(Z,NIN,ZZ1);
					ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
					if (ZZ2 < ZZA)
						ZZ2 = ZZA+0.001;      
					end 			   
					if (ZZ2 > ZZB)
						ZZ2 = ZZB-0.01;
					end 			   
					D0 = D1;
					ZZ0 = ZZ1;
					ZZ1 = ZZ2;
				end 			   
				Zm = [Zm sqrt(ZZ2)];
			end 			    
			% Last arc    
			ZZ2 = 1; % 0.9999999
			Zm = [Zm ZZ2];
		elseif N == 1    
			ZZ2 = 1; % 0.9999999
			Zm = [Zm ZZ2];
		else
			disp('Not a positive number of attenuation poles-no arcmin')  
		end
	else
		disp('Error-Negative number of attenuation poles at infinity.')
	end
